#!/bin/bash


GEN="$PWD/../gen-sitemap"

if [ -x "$GEN" ] ; then
    echo "testing gen-sitemap..."
else
    echo "Am I in the right directory?"
    exit 1
fi

rm -Rf www-test/

export LANG=C
export TZ=UTC


### test 1 ###

mkdir www-test/
cd www-test/

touch index.html  -t 200712281558.00
touch other.html  -t 200712281558.01
touch special.spc -t 200712281558.05
mkdir ignore
touch ignore/index.html  -t 200712281558.10
touch ignore/ignore.html -t 200712281558.11
mkdir ignore/unignore
touch ignore/unignore/index.html  -t 200712281558.20
touch ignore/unignore/ignore.html -t 200712281558.21
mkdir private
touch private/priv.html  -t 200712281558.31
mkdir sub
touch sub/index.html     -t 200712281558.40
touch sub/important.html -t 200712281558.41
mkdir sub/sub2
touch sub/sub2/index.html     -t 200712281558.42
touch sub/sub2/important.html -t 200712281558.43
mkdir sub/sub2a
touch sub/sub2a/index.html     -t 200712281558.44
touch sub/sub2a/important.html -t 200712281558.45
mkdir sub/sub2/sub3
touch sub/sub2/sub3/index.html     -t 200712281558.46
touch sub/sub2/sub3/important.html -t 200712281558.47
mkdir stop
touch stop/index.html  -t 200712281558.51
touch stop/ignore.html -t 200712281558.52
mkdir stop/unignore
touch stop/unignore/index.html  -t 200712281558.53
touch stop/unignore/ignore.html -t 200712281558.54
mkdir stop/unignore/important
touch stop/unignore/important/index.html  -t 200712281558.55
touch stop/unignore/important/ignore.html -t 200712281558.56


$GEN --conf=../sitemap-1.conf
cmp sitemap-1.xml ../ref-sitemap-1.xml || echo "test-1 error"

cp ../sitemap-2.list .
$GEN --conf=../sitemap-2.conf
gunzip -cd sitemap-2.xml.gz | cmp ../ref-sitemap-1.xml - || echo "test-2 error"

$GEN --conf=../sitemap-3.conf
cmp sitemap-3.xml ../ref-sitemap-3.xml || echo "test-3 error"

cp ../sitemap-4.inc.xml .
$GEN --conf=../sitemap-4.conf
cmp sitemap-4.xml ../ref-sitemap-4.xml || echo "test-4 error"

$GEN --conf=../sitemap-5.conf
d1="$(date +%s -r sitemap-5-html.xml)"
cat sitemap-5.xml | sed -e "s/>$(date --rfc-3339=date)T[0-9:]*Z</>0000-00-00T00:00:00Z</" - > sitemap-5a.xml.tmp
cmp sitemap-5a.xml.tmp ../ref-sitemap-5a.xml || echo "test-5a error (1)"
cmp sitemap-5-0.xml ../ref-sitemap-5-0.xml || echo "test-5a error (2)"
cmp sitemap-5-html.xml ../ref-sitemap-5-html.xml || echo "test-5a error (3)"
cmp sitemap-5-stop.xml ../ref-sitemap-5-stop.xml|| echo "test-5a error (4)"

# force timestamp, so see if we modify it
touch -t 200712281558.59 sitemap-5-0.xml sitemap-5-html.xml sitemap-5-stop.xml
eref="$(date +%s -r sitemap-5-0.xml)"
touch -t 200712300211.22 sub/sub2a/important.html
sleep 2
$GEN --conf=../sitemap-5.conf
e0="$(date +%s -r sitemap-5-0.xml)"
e1="$(date +%s -r sitemap-5-html.xml)"
e2="$(date +%s -r sitemap-5-stop.xml)"
cat sitemap-5.xml | sed -e "s/>$(date --rfc-3339=date)T[0-9:]*Z</>0000-00-00T00:00:00Z</" - > sitemap-5b.xml.tmp
cmp sitemap-5b.xml.tmp ../ref-sitemap-5b.xml || echo "test-5b error (1)"
cmp sitemap-5-0.xml ../ref-sitemap-5-0.xml || echo "test-5b error (2)"
cmp sitemap-5-html.xml ../ref-sitemap-5b-html.xml || echo "test-5b error (3)"
cmp sitemap-5-stop.xml ../ref-sitemap-5-stop.xml|| echo "test-5b error (4)"
[ "$e0" -eq "$eref" ] || echo "test-5b error (5)"
[ "$e1" -gt "$d1" ]   || echo "test-5b error (6)"
[ "$e2" -eq "$eref" ] || echo "test-5b error (7)"

