#: lkddb/linux/browser_build : browsers for linux kernel infrastructuve
#
#  Copyright (c) 2000,2001,2007-2009  Giacomo A. Catenazzi <cate@cateee.net>
#  This is free software, see GNU General Public License v2 for details

import os
import os.path
import re
import subprocess
import fnmatch
import lkddb

# kernel version and name

class kver(lkddb.browser):
    def __init__(self, kver_table, kerneldir):
        lkddb.browser.__init__(self, "kver")
	self.table = kver_table
	self.kerneldir = kerneldir

    def scan(self):
        "Makefile, scripts/setlocalversion -> return (ver_number, ver_string, released)" 
	lkddb.browser.scan(self)
        dict = {}
        f = open(os.path.join(self.kerneldir, "Makefile"))
	for i in range(10):
	    line = f.readline().strip()
	    if not line or line[0] == '#':
		continue
	    try:
		label, value = line.split('=', 1)
	    except ValueError:
		continue
	    dict[label.strip()] = value.strip()
	f.close()
	assert(dict.has_key("VERSION"))
	assert(dict.has_key("PATCHLEVEL"))
	assert(dict.has_key("SUBLEVEL"))
	assert(dict.has_key("EXTRAVERSION"))

        version =  ( int(dict["VERSION"])    * 0x10000 +
		         int(dict["PATCHLEVEL"]) * 0x100   +
		         int(dict["SUBLEVEL"])   )
        extra = dict["EXTRAVERSION"]
        ver_str = dict["VERSION"] +"."+ dict["PATCHLEVEL"] +"."+ dict["SUBLEVEL"] + extra

        local_ver = subprocess.Popen("/bin/sh scripts/setlocalversion",
		shell=True, cwd=self.kerneldir,
		stdout=subprocess.PIPE).communicate()[0].strip() # .replace("-dirty", "")
        if local_ver  or  not extra.isdigit():
	    # not a x.y.z or x.y.z.w release
            ver_str = ver_str + local_ver
            is_a_release = 1
        else:
            is_a_release = 0
	name = dict.get("NAME", '(not named)')

	self.table.add_row((version, ver_str, is_a_release, name))
        lkddb.share('kver', version)
	lkddb.share('kver_str', ver_str)


# parse kbuild files (Makefiles) and extract the file dependencies

kbuild_normalize = re.compile(
	r"(#.*$|\\[ \t]*\n)", re.MULTILINE)
kbuild_includes = re.compile(
	r"^\s*include\s+\$[\(\{]srctree[\)\}]/(.*)$", re.MULTILINE)
kbuild_rules = re.compile(
	r"^([A-Za-z0-9-_]+)-([^+=: \t\n]+)\s*[:+]?=[ \t]*(.*)$", re.MULTILINE)

ignore_rules_set = frozenset(
#    ("init", "drivers", "net", "libs", "core", "obj", "lib",
     ("cflags", "cpuflags"))


# note: it provides no devices (yet)

class makefiles(lkddb.browser):
    def __init__(self, kerneldir, dirs):
        lkddb.browser.__init__(self, "kmake")
        self.kerneldir = kerneldir
	self.dirs = dirs
        # dictionary of CONFIG_ dependencies on files (from Makefile)
        # format: filename.c: (CONFIG_FOO, CONFIG_BAR)
        self.dependencies = {}
        # format: filename.c: (virtual-filename-objs.c, ...)
        self.dep_aliases = {}
        # the inverse; format CONFIG_FOO: name  (used for module, so single name)
        self.modules = {}
        # share
	lkddb.shared['kmake_dep'] = self.dependencies
	lkddb.shared['kmake_dep_alias'] = self.dep_aliases
	lkddb.shared['kmake_modules'] = self.modules

    def scan(self):
	lkddb.browser.scan(self)
        orig_cwd = os.getcwd()
        try:
            os.chdir(self.kerneldir)
            for subdir in self.dirs:
                if subdir == "arch":
                    for arch in os.listdir("arch/"):
                        mk2 = os.path.join("arch/", arch)
                        self.__parse_kbuild(mk2)
                else:
                    self.__parse_kbuild(subdir)
        finally:
            os.chdir(orig_cwd)


    def __parse_kbuild(self, subdir, deps=None):
        try:
            files = os.listdir(subdir)
        except OSError:
            lkddb.log("parse_kbuild: I don't know the directory %s" % subdir)
            return
        if "Kbuild" in files:
            source = "Kbuild"
        elif "Makefile" in files:
            source = "Makefile"
        elif deps == None:
            lkddb.log("No Makefile in %s, recursing..." % subdir)
            for dir in files:
                if os.path.isdir(os.path.join(subdir, dir)):
                    self.__parse_kbuild(os.path.join(subdir, dir), deps)
            return
        else:
            lkddb.log("No Makefile in %s" % subdir)
            return
        mk = os.path.normpath(os.path.join(subdir, source))

        f = open(mk)
        src = kbuild_normalize.sub(" ", f.read())
        f.close()
        for incl in kbuild_includes.findall(src):
            mk2 = os.path.normpath(incl)
            # print "check--------------", mk, "includes", mk2 ####################
            if not os.path.isfile(mk2):
                lkddb.log("parse_kbuild: could not find included file (from %s): %s" %
				(mk, mk2))
                return
            f = open(mk2)
            src += " " + kbuild_normalize.sub(" ", f.read())
            f.close()
        if deps == None:
            deps = set()
        if subdir.startswith("arch/")  and  subdir.count("/") == 1:
            base_subdir = ""
        else:
            base_subdir = subdir
        self.__parse_kbuild_lines(base_subdir, deps, src)


    def __parse_kbuild_alias(self, subdir, deps, rule, dep, files):
        for f in files.split():
            fn = os.path.normpath(os.path.join(subdir, f))
            if f[-2:] == ".o":
                fc = fn[:-2]+".c"
                virt = [ os.path.join(subdir, rule+".c") ]
                if self.dep_aliases.has_key(fc):
                    virt.extend(self.dep_aliases[fc])
                self.dep_aliases[fc] = virt
            elif f[-1] == "/":
                self.__parse_kbuild(fn, dep)

    def __parse_kbuild_lines(self, subdir, deps, src):
        for (rule, dep, files) in kbuild_rules.findall(src):
            d = deps.copy()
            if not files:
                pass
            # rule-$(dep): file.o
            if dep in ("y", "m") or  rule == "clean":
                pass
            elif (dep[:9] == '$(CONFIG_' and dep[-1] == ')') or (
                  dep[:9] == '${CONFIG_' and dep[-1] == '}'):
                i = dep[:-1].find(')', 2)
                if i > 0 and dep[i+1:i+10] == "$(CONFIG_":
                    d.add(dep[2:i])
                    self.modules[dep[2:i]] = files
                    d.add(dep[i+3:-1])
                    self.modules[dep[i+3:-1]] = files
                else:
                    d.add(dep[2:-1])
                    self.modules[dep[2:-1]] = files
            elif dep == "objs":
                self.__parse_kbuild_alias(subdir, deps, rule, dep, files)
                continue
            else:
                lkddb.log("parse_kbuild: unknow dep in %s: '%s'" % (subdir, dep))
                continue

            for f in files.split():
                fn = os.path.join(subdir, f)
                if f[-1] == "/":
                    self.__parse_kbuild(fn, d)
                elif f[-2:] == ".o":
                    fc = fn[:-2]+".c"
                    v = d.copy()
                    if self.dependencies.has_key(fc):
                        v.update(self.dependencies[fc])
                    self.dependencies[fc] = v
                else:
                    lkddb.log_extra(
			"parse_kbuild: unknow 'make target' in %s: '%s'" % (subdir, f))

            if not rule in ignore_rules_set:
                self.__parse_kbuild_alias(subdir, deps, rule, d, files)

# -----

    def _list_dep_rec(self, fn, dep, passed):
        if dep == None:
            dep = set()
        key = self.dependencies.get(fn, None)
        if key != None:
            dep.update(key)
        keys = self.dep_aliases.get(fn, None)
        if key != None:
            for alias in keys:
                if alias in passed:
                    continue
                else:
                    passed.add(alias)
                dep.update(self._list_dep_rec(alias, dep, passed))
        return dep

    def list_dep(self, fn):
        dep = set()
        passed = set([fn])
        self._list_dep_rec(fn, dep, passed)
        if not dep:
            return set( ["CONFIG__UNKNOW__"] )
        return dep

# parse kconfig files
# Note: one sources, two devices

tristate_re = re.compile(r'^config\s*(\w+)\s+tristate\s+"(.*?[^\\])"',
							re.DOTALL | re.MULTILINE)
kconf_re = re.compile(r"^(?:menu)?config\s+(\w+)\s*\n(.*?)\n[a-z]",
					                re.MULTILINE | re.DOTALL)
# context
C_TOP=0; C_CONF=1; C_HELP=2


class kconfigs(lkddb.browser):
    def __init__(self, kconf_table, module_table, kerneldir, dirs, makefiles):
        lkddb.browser.__init__(self, "kconfigs")
	self.kconf_table = kconf_table
	self.module_table = module_table
        self.kerneldir = kerneldir
	self.dirs = dirs
	self.makefiles = makefiles
	# two kind of "devices": config and module

    def scan(self):
	lkddb.browser.scan(self)
        orig_cwd = os.getcwd()
        try:
            os.chdir(self.kerneldir)
            for subdir in self.dirs:
                for dir, d_, files in os.walk(subdir):
                    for kconf in fnmatch.filter(files, "Kconfig*"):
                        filename = os.path.join(dir, kconf)
                        lkddb.log_extra("Kconfig doing: " + filename)
                        self.__parse_kconfig(filename)
        finally:
            os.chdir(orig_cwd)

    def finalize(self):
	lkddb.browser.finalize(self)

    def __parse_kconfig(self, filename):
        "read config menu in Kconfig"
        f = open(filename)
        context = C_TOP
        config = None
        depends = []
        for line in f:
            line = line.expandtabs()
            if context == C_HELP:
                ident_new = len(line) - len(line.lstrip())
                if ident < 0:
                    ident = ident_new
                if ident_new >= ident  or  line.strip() == "":
                    help += line.strip() + "\n"
                    continue
                context = C_CONF
            line = line.strip()
            if len(line) == 0  or  line[0] == "#":
                continue
            try:
                tok,args = line.split(None, 1)
            except:
                tok = line ; args = ""
            if tok in frozenset(("menu", "endmenu", "source", "if", "endif", "endchoice", "mainmenu")):
                if context == C_CONF:
                    self.__kconf_save(config, dict, type, descr, depends, help, filename)
                context = C_TOP
                continue
            if tok in frozenset(("config", "menuconfig", "choice")):
                if context == C_CONF:
                    self.__kconf_save(config, dict, type, descr, depends, help, filename)
                else:
                    context = C_CONF
                config = args
                help = ""
                dict = {}
                type = None
                descr = ""
                depends = []
                continue
            if tok in frozenset(("help", "---help---")):
                if context != C_CONF:
                    help = ""
                    lkddb.log(
			"kconfig: error help out of context (%s), in %s, after '%s'" %
                               				(context, filename, config))
                context = C_HELP
                ident = -1
                continue
            if tok in frozenset(("bool", "tristate", "string", "hex", "int")):
                type = tok
                if not args:
                    descr = ""
                else:
                    div = args[0]
                    if not (div == '"'  or  div == "'"):
                        descr = args
                        lkddb.log("kconfig: bad line in %s %s: '%s'" %
								(filename, config, line))
                    else:
                        if div == '"':
                            args = args.replace('\\"', "'").replace("\\'", "'")
                            s =  args.split(div)
                            descr = s[1]
                        else:
                            args = args.replace('\\"', '"').replace("\\'", '"')
                            s = args.split(div)
                            descr = s[1].replace('"', "'")
                        d = s[2].split()
                        if len(d) > 1  and  d[0] == "if":
                            depends.append(" ".join(d[1:]))
            if tok in frozenset(("default", "def_bool", "def_tristate")):
                if tok[3] == "_":
                    type = tok[4:]
                    descr = ""
                s = args.split('if')
                if len(s) > 1:
                    d = s[1].split()
                    depends.append(" ".join(d))
            if tok == "prompt":
                div = args[0]
                assert div == '"'  or  div == "'"
                if div == '"':
                    args = args.replace('\\"', "'").replace("\\'", "'")
                    s =  args.split(div)
                    descr = s[1]
                else:
                    args = args.replace('\\"', '"').replace("\\'", '"')
                    s = args.split(div)
                    descr = s[1].replace('"', "'")
                d = s[2].split()
                if len(d) > 1  and  d[0] == "if":
                    depends.append(" ".join(d[1:]))
            if tok == "depends":
               d = args.split()
               if len(d) > 1  and  d[0] == "on":
                    depends.append(" ".join(d[1:]))
               else:
                    assert "false"
            if not context == C_CONF:
                # e.g. depents after "menu" or prompt and default after "choice"
                continue
            dict[tok] = args
        if context == C_CONF:
            self.__kconf_save(config, dict, type, descr, depends, help, filename)


    def __kconf_save(self, config, dict, type, descr, depends, help, filename):
        if not type:  # e.g. on 'choice'
            return
        config = "CONFIG_" + config
        if depends:
            if len(depends) > 1:
                depends = '(' +   ")  &&  (".join(depends)  + ')'
            else:
                depends = depends[0]
        else:
            depends = ""
	self.kconf_table.add_row((config, filename, type, descr, depends, help.strip()))

        if type == "tristate"  or  type == "def_tristate":
	    mod = self.makefiles.modules.get(config, None)
            if mod:
                for name in mod.split():
                    if not name.endswith(".o"):
                        if name[-1] == "/":
                            lkddb.log(
				"Kconfig: name %s does'n ends with '.o (%s from %s)"
							% (name, config, filename))
                        continue
		    self.module_table.add_row((name[:-2], descr, config, filename))
            else:
                lkddb.log("kconfig: could not find the module obj of %s from %s" % (config, filename))

