import lkddb
import lkddb.linux
import lkddb.tables
import sys
lkddb.init(2, sys.stdout)
from lkddb.linux.browse_sources import *
from lkddb import register_browser, register_scanner, get_table
from lkddb.linux.kbuild import kver, makefiles, kconfigs
from lkddb.linux.parse_devicetables import *
from lkddb import register_table
register_table('kver', lkddb.tables.linux_kbuild.kver_table())
kver_ = kver(get_table('kver'), '/home/cate/linux-2.6.30/')
register_table('kconf', lkddb.tables.linux_kbuild.kconf_table())
register_table('module', lkddb.tables.linux_kbuild.module_table())
register_browser(kver_)

kerneldir= '/home/cate/linux-2.6.30/'
#dirs = ("arch", "block", "crypto", "drivers", "fs", "init",
#                "ipc", "kernel", "lib", "mm", "net", "security",
#                "sound", "virt")
dirs = ("drivers/net/tokenring",)

makefiles_ = makefiles(kerneldir, dirs)
register_browser(makefiles_)

kconfigs_ = kconfigs(get_table('kconf'),
                         get_table('module'), kerneldir, dirs, makefiles_)

register_browser(kconfigs_)

mod = get_table('module')



sources_ = linux_sources(kerneldir, dirs)
register_browser(sources_)
parent_scanner = struct_parent_scanner(sources_, makefiles_)
pci_table_ = lkddb.tables.linux_devicetables.pci_table()
register_table('pci', pci_table_)
pci_ = pci(parent_scanner)
register_scanner(pci_)


lkddb.scan_sources()
lkddb.finalize_sources()


makefiles_.dep_aliases['fs/9p/vfs_super.c']
makefiles_.list_dep('fs/9p/vfs_super.c')




makefiles_.dep_aliases['drivers/s390/scsi/zfcp_ccw.c']
makefiles_.list_dep('drivers/s390/scsi/zfcp_ccw.c')

makefiles_.dep_aliases['fs/9p/vfs_super.c']
makefiles_.list_dep('fs/9p/vfs_super.c')

